/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.client.ModClient;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerInfoWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerListWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.AutoScaledStringWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7842;

public class PlayerInfoWidget
extends class_339 {
    private static final class_2960 TRAINER_CARD_IMAGE_LOCATION = new class_2960("rctmod", "textures/gui/trainer_card.png");
    private static final int TRAINER_CARD_IMAGE_X = 0;
    private static final int TRAINER_CARD_IMAGE_Y = 0;
    private static final int TRAINER_CARD_IMAGE_W = 224;
    private static final int TRAINER_CARD_IMAGE_H = 128;
    private static final int SKIN_X = 13;
    private static final int SKIN_Y = 32;
    private static final int SKIN_SIZE = 72;
    private static final int DISPLAY_NAME_X = 16;
    private static final int DISPLAY_NAME_Y = 8;
    private static final int DISPLAY_NAME_W = 66;
    private static final int DISPLAY_NAME_H = 16;
    private static final int LEVEL_CAP_X = 8;
    private static final int LEVEL_CAP_Y = 104;
    private static final int LEVEL_CAP_W = 82;
    private static final int LEVEL_CAP_H = 16;
    private static final int LEVEL_CAP_PADDING = 4;
    private static final int TOTAL_DEFEATS_X = 96;
    private static final int TOTAL_DEFEATS_Y = 104;
    private static final int TOTAL_DEFEATS_W = 88;
    private static final int TOTAL_DEFEATS_H = 16;
    private static final int TOTAL_DEFEATS_PADDING = 4;
    private static final int TRAINER_LIST_X = 96;
    private static final int TRAINER_LIST_Y = 32;
    private static final int TRAINER_LIST_W = 112;
    private static final int TRAINER_LIST_H = 72;
    private static final int TYPE_BUTTON_X = 96;
    private static final int TYPE_BUTTON_Y = 8;
    private static final int TYPE_BUTTON_W = 100;
    private static final int TYPE_BUTTON_H = 16;
    private static final int CHECKBOX_X = 196;
    private static final int CHECKBOX_Y = 8;
    private static final int CHECKBOX_W = 20;
    private static final int CHECKBOX_H = 16;
    private static final int NEXT_PAGE_BUTTON_X = 200;
    private static final int NEXT_PAGE_BUTTON_Y = 104;
    private static final int NEXT_PAGE_BUTTON_SIZE = 16;
    private static final String ALL_TRAINER_TYPES_STR = "ALL";
    private final class_7842 displayName;
    private final class_7842 levelCapLabel;
    private final class_7842 levelCapValue;
    private final class_7842 totalDefeatsLabel;
    private final class_7842 totalDefeatsValue;
    private final TrainerListWidget trainerList;
    private final TrainerInfoWidget trainerInfo;
    private final class_5676<String> trainerTypeButton;
    private final class_4185 nextPageButton;
    private final class_4185 prevPageButton;
    private final class_4286 showUndefeated;
    private final class_339[] renderableWidgets;
    private final class_339[] renderableOnlies;
    private Boolean trainerListShowUndefeated;
    private class_2561 trainerListType;
    private class_2960 skinLocation;
    private class_327 font;

    public PlayerInfoWidget(int x, int y, int w, int h, class_327 font) {
        super(x, y, w, h, (class_2561)class_2561.method_43473());
        this.field_22763 = false;
        this.font = font;
        this.displayName = new AutoScaledStringWidget(x + 16, y + 8, 66, 16, (class_2561)class_2561.method_43473(), this.font).alignCenter().fitting(true);
        this.levelCapLabel = new class_7842(x + 8 + 4, y + 104 + 2, 82, 16, (class_2561)class_2561.method_43470((String)"Level Cap").method_27692(class_124.field_1068), this.font).method_48596();
        this.levelCapValue = new class_7842(x + 8, y + 104 + 2, 78, 16, (class_2561)class_2561.method_43473(), this.font).method_48599();
        this.totalDefeatsLabel = new class_7842(x + 96 + 4, y + 104 + 2, 88, 16, (class_2561)class_2561.method_43470((String)"Total").method_27692(class_124.field_1068), this.font).method_48596();
        this.totalDefeatsValue = new class_7842(x + 96, y + 104 + 2, 84, 16, (class_2561)class_2561.method_43473(), this.font).method_48599();
        this.trainerList = new TrainerListWidget(x + 96, y + 32, 112, 72, font, PlayerInfoWidget.sortedTrainerIds());
        this.trainerInfo = new TrainerInfoWidget(x + 96, y + 32, 112, 72, font);
        ArrayList<String> types = new ArrayList<String>();
        types.add(ALL_TRAINER_TYPES_STR);
        types.addAll(Stream.of(TrainerMobData.Type.values()).map(type -> type.name()).toList());
        this.showUndefeated = new class_4286(x + 196, y + 8, 20, 16, (class_2561)class_2561.method_43473(), true);
        this.trainerTypeButton = class_5676.method_32606(t -> class_2561.method_43470((String)t)).method_32620(types).method_32619((Object)ALL_TRAINER_TYPES_STR).method_35723(x + 96, y + 8, 100, 16, (class_2561)class_2561.method_43473());
        this.nextPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), this::onNextPage).method_46433(x + 200, y + 104).method_46437(16, 16).method_46431();
        this.prevPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), this::onPrevPage).method_46433(x + 200 - 16, y + 104).method_46437(16, 16).method_46431();
        this.renderableWidgets = new class_339[]{this.trainerList, this.trainerInfo, this.trainerTypeButton, this.showUndefeated, this.prevPageButton, this.nextPageButton};
        this.renderableOnlies = new class_339[]{this.displayName, this.levelCapLabel, this.levelCapValue, this.totalDefeatsLabel, this.totalDefeatsValue};
        this.trainerList.setOnTrainerClicked((trainerNr, trainerId, entryState) -> {
            this.trainerInfo.initTrainerInfo(trainerNr, trainerId, entryState);
            this.trainerInfo.setPage(0);
            this.setDisplay(Display.TRAINER_INFO);
        });
        this.trainerInfo.setOnBackClicked(i -> this.setDisplay(Display.TRAINER_LIST));
        this.setDisplay(Display.TRAINER_LIST);
    }

    public class_339[] getRenderableWidgets() {
        return this.renderableWidgets;
    }

    public class_339[] getRenderableOnlies() {
        return this.renderableOnlies;
    }

    public void setDisplay(Display display) {
        switch (display) {
            case TRAINER_LIST: {
                this.trainerInfo.field_22763 = false;
                this.trainerInfo.field_22764 = false;
                this.trainerList.field_22763 = true;
                this.trainerList.field_22764 = true;
                this.showUndefeated.field_22763 = true;
                this.trainerTypeButton.field_22763 = true;
                if (this.trainerListShowUndefeated != null) {
                    if (this.trainerListShowUndefeated.booleanValue() != this.showUndefeated.method_20372()) {
                        this.showUndefeated.method_25306();
                    }
                    this.trainerListShowUndefeated = null;
                }
                if (this.trainerListType == null) break;
                this.trainerTypeButton.method_25355(this.trainerListType);
                this.trainerListType = null;
                break;
            }
            case TRAINER_INFO: {
                if (this.trainerListShowUndefeated == null) {
                    this.trainerListShowUndefeated = this.showUndefeated.method_20372();
                }
                if (this.trainerListType == null) {
                    this.trainerListType = this.trainerTypeButton.method_25369();
                }
                if (this.showUndefeated.method_20372()) {
                    this.showUndefeated.method_25306();
                }
                this.trainerInfo.field_22763 = true;
                this.trainerInfo.field_22764 = true;
                this.trainerList.field_22763 = false;
                this.trainerList.field_22764 = false;
                this.showUndefeated.field_22763 = false;
                this.trainerTypeButton.field_22763 = false;
                this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
            }
        }
    }

    public void tick() {
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        int levelCap = playerState.getLevelCap();
        this.skinLocation = localPlayer.method_3117();
        this.displayName.method_25355((class_2561)class_2561.method_43470((String)localPlayer.method_5476().getString()).method_27692(class_124.field_1056).method_27692(class_124.field_1068));
        this.levelCapValue.method_25355((class_2561)(levelCap <= 100 ? class_2561.method_43470((String)String.valueOf(levelCap)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
        if (this.trainerList.field_22763) {
            long totalDefeats = this.getTotalDefeats();
            this.totalDefeatsValue.method_25355((class_2561)(totalDefeats < 1000000L ? class_2561.method_43470((String)String.valueOf(totalDefeats)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"1000000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
            this.nextPageButton.field_22763 = this.trainerList.getPage() < this.trainerList.getMaxPage();
            this.prevPageButton.field_22763 = this.trainerList.getPage() > 0;
            String trainerTypeStr = (String)this.trainerTypeButton.method_32603();
            boolean showUndefeated = this.showUndefeated.method_20372();
            boolean showAllTypes = trainerTypeStr.equals(ALL_TRAINER_TYPES_STR);
            if (!showAllTypes) {
                TrainerMobData.Type trainerType = TrainerMobData.Type.valueOf(trainerTypeStr);
                this.trainerList.setTrainerType(trainerType);
            }
            this.trainerList.setShowAllTypes(showAllTypes);
            this.trainerList.setShowUndefeated(showUndefeated);
            this.trainerList.tick();
        } else if (this.trainerInfo.field_22763) {
            int defeats = this.getDefeats(this.trainerInfo.getTrainerId());
            this.totalDefeatsValue.method_25355((class_2561)(defeats < 1000000 ? class_2561.method_43470((String)String.valueOf(defeats)).method_27692(class_124.field_1068) : class_2561.method_43470((String)"1000000").method_27692(class_124.field_1051).method_27692(class_124.field_1068)));
            this.nextPageButton.field_22763 = this.trainerInfo.getPage() < this.trainerInfo.getMaxPage();
            this.prevPageButton.field_22763 = this.trainerInfo.getPage() > 0;
        }
    }

    protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25302(TRAINER_CARD_IMAGE_LOCATION, this.method_46426(), this.method_46427(), 0, 0, 224, 128);
        if (this.skinLocation != null) {
            class_7532.method_44443((class_332)guiGraphics, (class_2960)this.skinLocation, (int)(this.method_46426() + 13), (int)(this.method_46427() + 32), (int)72);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private void onNextPage(class_4185 button) {
        if (this.trainerList.field_22763) {
            this.trainerList.setPage(this.trainerList.getPage() + 1);
        }
        if (this.trainerInfo.field_22763) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() + 1);
            this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private void onPrevPage(class_4185 button) {
        if (this.trainerList.field_22763) {
            this.trainerList.setPage(this.trainerList.getPage() - 1);
        }
        if (this.trainerInfo.field_22763) {
            this.trainerInfo.setPage(this.trainerInfo.getPage() - 1);
            this.trainerTypeButton.method_25355(this.trainerInfo.getPageContent((int)this.trainerInfo.getPage()).title);
        }
    }

    private long getTotalDefeats() {
        if (!this.showUndefeated.method_20372()) {
            return this.trainerList.getShowAllTypes() ? this.getDistinctDefeats() : this.getDistinctDefeats(this.trainerList.getTrainerType());
        }
        if (!this.trainerList.getShowAllTypes()) {
            return this.getTotalDefeats(this.trainerList.getTrainerType());
        }
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        return playerState.getTrainerDefeatCount();
    }

    private long getTotalDefeats(TrainerMobData.Type type) {
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        return playerState.getTypeDefeatCount(type);
    }

    private long getDistinctDefeats() {
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        int count = 0;
        for (TrainerMobData.Type t : TrainerMobData.Type.values()) {
            count = (int)((long)count + playerState.getTypeDefeatCount(t, true));
        }
        return count;
    }

    private long getDistinctDefeats(TrainerMobData.Type type) {
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        return playerState.getTypeDefeatCount(type, true);
    }

    private int getDefeats(String trainerId) {
        class_746 localPlayer = (class_746)ModClient.get().getLocalPlayer().get();
        PlayerState playerState = PlayerState.get((class_1657)localPlayer);
        return playerState.getTrainerDefeatCount(trainerId);
    }

    private static List<String> sortedTrainerIds() {
        TrainerManager tdm = RCTMod.get().getTrainerManager();
        return tdm.getAllData().map(entry -> (String)entry.getKey()).sorted((k1, k2) -> {
            TrainerMobData t1 = tdm.getData((String)k1);
            TrainerMobData t2 = tdm.getData((String)k2);
            int c = t1.getTeam().getMembers().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) - t2.getTeam().getMembers().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0);
            if (c == 0 && (c = t1.getTeam().getDisplayName().compareTo(t2.getTeam().getDisplayName())) == 0) {
                c = k1.compareTo((String)k2);
            }
            return c;
        }).toList();
    }

    public static enum Display {
        TRAINER_LIST,
        TRAINER_INFO;

    }
}

