/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.renderer;

import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TargetArrowRenderer {
    private static final float[] PYRAMID_STRIP = new float[]{0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] PYRAMID_COLORS = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float PYRAMID_ALPHA = 0.5f;
    private static final Vector3f PYRAMID_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final int TICKS_TO_ACTIVATE = 40;
    public static double TX = -0.15;
    public static double TY = 0.25;
    public static double TZ = 0.03;
    private static final float SX = 0.009375f;
    private static final float SY = 0.03f;
    private static final float SZ = 0.01875f;
    private Supplier<class_1792> itemSupplier;
    private Vector3f direction;
    private int sourceTicks;
    private int activationTicks;
    private boolean active;
    private static Supplier<TargetArrowRenderer> instanceSupplier = () -> {
        throw new IllegalStateException(TargetArrowRenderer.class.getName() + " not initialized");
    };

    public static void init(Supplier<class_1792> triggerItemSupplier) {
        TargetArrowRenderer instance = new TargetArrowRenderer(triggerItemSupplier);
        instanceSupplier = () -> instance;
    }

    public static TargetArrowRenderer getInstance() {
        return instanceSupplier.get();
    }

    private TargetArrowRenderer(Supplier<class_1792> triggerItemSupplier) {
        this.itemSupplier = triggerItemSupplier;
    }

    public void tick() {
        this.updateTarget();
        if (this.active) {
            if (this.activationTicks < 40) {
                ++this.activationTicks;
            }
        } else if (this.activationTicks > 0) {
            --this.activationTicks;
        }
    }

    public void render(class_4587 poseStack, float partialTick) {
        if (this.activationTicks > 0) {
            class_310 mc = class_310.method_1551();
            class_4184 cam = mc.field_1773.method_19418();
            if (cam.method_19332()) {
                float t = Math.min((float)this.activationTicks + partialTick, 40.0f) / 40.0f;
                Quaternionf rotation = new Quaternionf();
                this.direction.rotationTo((Vector3fc)PYRAMID_UP, rotation);
                poseStack.method_22903();
                poseStack.method_22904(TX, TY, TZ);
                poseStack.method_22907(cam.method_23767().difference(rotation).rotateLocalX((float)((double)(2.0f * cam.method_19329()) * Math.PI / 180.0)));
                poseStack.method_22907(new Quaternionf().rotateY((float)Math.PI * ((float)this.sourceTicks + partialTick) / 40.0f));
                poseStack.method_22905(0.009375f * t, (float)((double)0.03f + Math.sin(((float)this.sourceTicks + partialTick) / 10.0f) * 0.01) * t, 0.01875f * t);
                Matrix4f m = poseStack.method_23760().method_23761();
                class_289 tess = class_289.method_1348();
                class_287 buffer = tess.method_1349();
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.setShader(class_757::method_34540);
                buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
                for (int i = 0; i < PYRAMID_STRIP.length; i += 3) {
                    buffer.method_22918(m, PYRAMID_STRIP[i], PYRAMID_STRIP[i + 1], PYRAMID_STRIP[i + 2]).method_22915(PYRAMID_COLORS[i], PYRAMID_COLORS[i + 1], PYRAMID_COLORS[i + 2], 0.5f * t).method_1344();
                }
                poseStack.method_22909();
                tess.method_1350();
            }
        }
    }

    private void updateTarget() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null) {
            if (player.method_6047().method_31574(this.itemSupplier.get())) {
                this.setTarget((class_1297)player, PlayerState.get((class_1657)player).getTarget());
            } else {
                this.setTarget((class_1297)player, null);
            }
        }
    }

    private void setTarget(class_1297 source, class_1297 target) {
        this.sourceTicks = source.field_6012;
        boolean bl = this.active = target != null;
        if (this.active) {
            this.direction = target.method_19538().method_1020(source.method_19538()).method_46409();
        }
    }
}

