/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_7367;

public final class JsonUtils<T> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();

    private JsonUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(String json, Class<T> type) {
        try (BufferedReader rd = new BufferedReader(new StringReader(json));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(class_7367<InputStream> io, Class<T> type) {
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)io.get(), StandardCharsets.UTF_8));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(class_7367<InputStream> io, TypeToken<T> type) {
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)io.get(), StandardCharsets.UTF_8));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String toJson(T obj) {
        return GSON.toJson(obj);
    }
}

