/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedStringIntegerMap;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class TrainerSpawner {
    private static float KEY_TRAINER_SPAWN_WEIGHT_FACTOR = 120.0f;
    private static float UNDEFEATED_WEIGHT_FACTOR = 8.0f;
    private static final int SPAWN_RETRIES = 4;
    private static final boolean CAN_SPAWN_IN_WATER = false;
    private Map<String, Integer> spawns = new HashMap<String, Integer>();
    private Map<String, Integer> identities = new HashMap<String, Integer>();
    private Map<String, Integer> playerSpawns = new HashMap<String, Integer>();
    private Map<String, Integer> persistentSpawns;
    private Map<String, Integer> persistentNames;
    private Map<String, Integer> persistentPlayerSpawns;
    private Set<TrainerMob> mobs = new HashSet<TrainerMob>();
    private Map<UUID, Integer> tracked = new HashMap<UUID, Integer>();

    public void init(class_3218 level) {
        this.spawns.clear();
        this.identities.clear();
        this.playerSpawns.clear();
        this.mobs.clear();
        this.persistentSpawns = (Map)level.method_17983().method_17924(SavedStringIntegerMap::of, SavedStringIntegerMap::new, SavedStringIntegerMap.filePath("spawn.uuids"));
        this.persistentNames = (Map)level.method_17983().method_17924(SavedStringIntegerMap::of, SavedStringIntegerMap::new, SavedStringIntegerMap.filePath("spawn.names"));
        this.persistentPlayerSpawns = (Map)level.method_17983().method_17924(SavedStringIntegerMap::of, SavedStringIntegerMap::new, SavedStringIntegerMap.filePath("spawn.counts"));
        if (RCTMod.get().getServerConfig().logSpawning()) {
            ModCommon.LOG.info("Initialized trainer spawner" + this.persistentSpawns.keySet().stream().reduce("", (u1, u2) -> u1 + " " + u2));
        }
    }

    public void checkDespawns() {
        Iterator<TrainerMob> it = this.mobs.iterator();
        while (it.hasNext()) {
            TrainerMob mob = it.next();
            if (mob.method_31481() || mob.method_5947()) {
                it.remove();
                continue;
            }
            if (!mob.shouldDespawn()) continue;
            it.remove();
            mob.method_31472();
        }
    }

    public void register(TrainerMob mob) {
        Map<String, Integer> spawns;
        Map<String, Integer> map = spawns = mob.method_5947() ? this.persistentSpawns : this.spawns;
        if (!spawns.containsKey(mob.method_5845())) {
            IServerConfig config;
            Map<String, Integer> playerSpawns;
            String identity = RCTMod.get().getTrainerManager().getData(mob).getTeam().getIdentity();
            Map<String, Integer> identities = mob.method_5947() ? this.persistentNames : this.identities;
            UUID originPlayer = mob.getOriginPlayer();
            Map<String, Integer> map2 = playerSpawns = mob.method_5947() ? this.persistentPlayerSpawns : this.playerSpawns;
            if (originPlayer != null) {
                playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
                this.track(mob, originPlayer);
            }
            identities.compute(identity, (key, value) -> value == null ? 1 : value + 1);
            spawns.put(mob.method_5845(), 0);
            if (!mob.method_5947()) {
                this.mobs.add(mob);
            }
            if ((config = RCTMod.get().getServerConfig()).logSpawning()) {
                ModCommon.LOG.info(String.format("Registered%strainer '%s' (%s) to spawner, attached to %s (%d/%d), (%d/%d)", mob.method_5947() ? " persistent " : " ", mob.getTrainerId(), mob.method_5845(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregister(TrainerMob mob) {
        Map<String, Integer> spawns;
        Map<String, Integer> map = spawns = mob.method_5947() ? this.persistentSpawns : this.spawns;
        if (spawns.containsKey(mob.method_5845())) {
            Map<String, Integer> playerSpawns;
            String identity = RCTMod.get().getTrainerManager().getData(mob).getTeam().getIdentity();
            Map<String, Integer> identities = mob.method_5947() ? this.persistentNames : this.identities;
            UUID originPlayer = mob.getOriginPlayer();
            Map<String, Integer> map2 = playerSpawns = mob.method_5947() ? this.persistentPlayerSpawns : this.playerSpawns;
            if (originPlayer != null) {
                playerSpawns.compute(originPlayer.toString(), (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
                this.untrack(mob, originPlayer);
            }
            identities.compute(identity, (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
            spawns.remove(mob.method_5845());
            IServerConfig config = RCTMod.get().getServerConfig();
            if (config.logSpawning()) {
                ModCommon.LOG.info(String.format("Unregistered%strainer '%s' (%s) from spawner, attached to %s (%d/%d), (%d/%d)", mob.method_5947() ? " persistent " : " ", mob.getTrainerId(), mob.method_5845(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregisterPersistent(String mobUUID) {
        this.persistentNames.remove(mobUUID);
        this.persistentSpawns.remove(mobUUID);
        this.persistentPlayerSpawns.remove(mobUUID);
    }

    public boolean isRegistered(TrainerMob mob) {
        return this.spawns.containsKey(mob.method_5845()) || this.persistentSpawns.containsKey(mob.method_5845());
    }

    public void notifyChangeTrainerId(TrainerMob mob, String newTrainerId) {
        Map<String, Integer> spawns;
        Map<String, Integer> map = spawns = mob.method_5947() ? this.persistentSpawns : this.spawns;
        if (spawns.containsKey(mob.method_5845())) {
            ModCommon.LOG.info(String.format("Changing trainer id '%s' -> '%s' (%s)", mob.getTrainerId(), newTrainerId, mob.method_5845()));
            String identity = RCTMod.get().getTrainerManager().getData(mob).getTeam().getIdentity();
            String newIdentity = RCTMod.get().getTrainerManager().getData(newTrainerId).getTeam().getIdentity();
            Map<String, Integer> identities = mob.method_5947() ? this.persistentNames : this.identities;
            identities.compute(identity, (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
            identities.compute(newIdentity, (key, value) -> value == null ? 1 : value + 1);
        }
    }

    public void notifyChangeOriginPlayer(TrainerMob mob, UUID newOriginPlayer) {
        Map<String, Integer> spawns;
        Map<String, Integer> map = spawns = mob.method_5947() ? this.persistentSpawns : this.spawns;
        if (spawns.containsKey(mob.method_5845())) {
            Map<String, Integer> playerSpawns;
            UUID originPlayer = mob.getOriginPlayer();
            Map<String, Integer> map2 = playerSpawns = mob.method_5947() ? this.persistentPlayerSpawns : this.playerSpawns;
            if (originPlayer != null) {
                playerSpawns.compute(originPlayer.toString(), (key, value) -> value == 1 ? null : Integer.valueOf(value - 1));
                this.untrack(mob, originPlayer);
            }
            if (newOriginPlayer != null) {
                playerSpawns.compute(newOriginPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
                this.track(mob, newOriginPlayer);
            }
        }
    }

    public void notifyChangePersistence(TrainerMob mob, boolean newPersistence) {
        if (this.spawns.containsKey(mob.method_5845())) {
            this.unregister(mob);
            mob.setPersistent(newPersistence);
            this.register(mob);
        }
    }

    public int getSpawnCount() {
        return this.spawns.size();
    }

    public int getSpawnCount(UUID playerId) {
        if (playerId != null) {
            return this.playerSpawns.getOrDefault(playerId.toString(), 0);
        }
        return 0;
    }

    public void attemptSpawnFor(class_1657 player) {
        IServerConfig config = RCTMod.get().getServerConfig();
        if (config.globalSpawnChance() < (double)player.method_6051().method_43057() || RCTMod.get().getTrainerManager().getPlayerLevel(player) == 0) {
            return;
        }
        if (this.getSpawnCount() < config.maxTrainersTotal() && this.getSpawnCount(player.method_5667()) < config.maxTrainersPerPlayer()) {
            for (int i = 0; i < 4; ++i) {
                class_2338 pos = this.nextPos(player);
                if (pos == null) continue;
                SpawnCandidate spawnCandidate = this.nextSpawnCandidate(player, pos);
                if (spawnCandidate == null) break;
                this.spawnFor(player, spawnCandidate.id, pos);
                break;
            }
        }
    }

    private boolean isUnique(String identity) {
        return !this.identities.containsKey(identity) && !this.persistentNames.containsKey(identity);
    }

    private void spawnFor(class_1657 player, String trainerId, class_2338 pos) {
        IServerConfig config = RCTMod.get().getServerConfig();
        class_1937 level = player.method_37908();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().method_5883(level);
        mob.method_33574(pos.method_46558().method_1031(0.0, -0.5, 0.0));
        mob.setTrainerId(trainerId);
        mob.setOriginPlayer(player.method_5667());
        level.method_8649((class_1297)mob);
        this.register(mob);
        if (config.logSpawning()) {
            String trainer = RCTMod.get().getTrainerManager().getData(trainerId).getTeam().getDisplayName();
            class_6880 biome = level.method_23753(mob.method_24515());
            class_5321 dim = level.method_27983();
            ModCommon.LOG.info(String.format("Spawned trainer '%s' (%s) at (%d, %d, %d), %s:%s", trainer, mob.getTrainerId(), mob.method_24515().method_10263(), mob.method_24515().method_10264(), mob.method_24515().method_10260(), dim.method_29177().method_12832(), biome.method_40228().map(t -> t.comp_327().method_12832()).reduce("", (t1, t2) -> t1 + " " + t2)));
        }
    }

    private class_2338 nextPos(class_1657 player) {
        IServerConfig config = RCTMod.get().getServerConfig();
        class_1937 level = player.method_37908();
        class_5819 rng = player.method_6051();
        int d = config.maxHorizontalDistanceToPlayers() - config.minHorizontalDistanceToPlayers();
        int dx = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.method_43054()) % d) * (rng.method_43054() < 0 ? -1 : 1);
        int dz = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.method_43054()) % d) * (rng.method_43054() < 0 ? -1 : 1);
        int dy = rng.method_43054() > 0 ? config.maxVerticalDistanceToPlayers() : -config.maxVerticalDistanceToPlayers();
        int x = player.method_31477() + dx;
        int z = player.method_31479() + dz;
        int y = player.method_31478();
        int yEnd = dy > 0 ? -(dy + 1) : -(dy - 1);
        int yAdd = dy > 0 ? -1 : 1;
        int prevState = -1;
        int validCount = 0;
        for (int i = dy; i != yEnd; i += yAdd) {
            class_2338 pos = new class_2338(x, y + i, z);
            class_2680 bs = level.method_8320(pos);
            if (bs.method_27852(class_2246.field_10477)) {
                validCount = dy < 0 ? (prevState == 3 ? 1 : 0) : (prevState == 0 ? ++validCount : 0);
                prevState = 2;
            } else if (bs.method_26206((class_1922)level, pos, class_2350.field_11036)) {
                validCount = dy < 0 ? 1 : (prevState == 0 || prevState == 1 ? ++validCount : 0);
                prevState = 3;
            } else if (bs.method_26215()) {
                if (dy < 0) {
                    if (validCount > 0) {
                        ++validCount;
                    }
                } else {
                    validCount = Math.min(2, validCount + 1);
                }
                prevState = 0;
            } else {
                prevState = -1;
                validCount = 0;
            }
            if (validCount <= 2) continue;
            return dy < 0 ? pos.method_10074() : pos.method_10084();
        }
        return null;
    }

    private SpawnCandidate nextSpawnCandidate(class_1657 player, class_2338 pos) {
        ArrayList<SpawnCandidate> candidates;
        block2: {
            Set tags;
            block3: {
                candidates = new ArrayList<SpawnCandidate>();
                class_1937 level = player.method_37908();
                tags = level.method_23753(pos).method_40228().map(t -> t.comp_327().method_12836() + ":" + t.comp_327().method_12832()).collect(Collectors.toSet());
                level.method_23753(pos).method_40228().map(t -> t.comp_327().method_12832()).forEach(t -> tags.add(t));
                IServerConfig config = RCTMod.get().getServerConfig();
                if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                if (config.biomeTagWhitelist().isEmpty()) break block3;
                if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
            }
            RCTMod.get().getTrainerManager().getAllData().filter(e -> {
                if (!this.isUnique(((TrainerMobData)e.getValue()).getTeam().getIdentity())) return false;
                if (!((TrainerMobData)e.getValue()).getBiomeTagBlacklist().stream().noneMatch(tags::contains)) return false;
                if (((TrainerMobData)e.getValue()).getBiomeTagWhitelist().isEmpty()) return true;
                if (!((TrainerMobData)e.getValue()).getBiomeTagWhitelist().stream().anyMatch(tags::contains)) return false;
                return true;
            }).forEach(e -> {
                double weight = this.computeWeight(player, (String)e.getKey(), (TrainerMobData)e.getValue());
                if (weight > 0.0) {
                    candidates.add(new SpawnCandidate((String)e.getKey(), weight));
                }
            });
        }
        return candidates.size() > 0 ? this.selectRandom(player.method_6051(), candidates) : null;
    }

    private SpawnCandidate selectRandom(class_5819 rng, List<SpawnCandidate> candidates) {
        int i;
        Double totalWeight = candidates.stream().map(c -> c.weight).reduce(0.0, (a, b) -> a + b);
        double r = rng.method_43058() * totalWeight;
        for (i = 0; i < candidates.size() - 1 && !((r -= candidates.get((int)i).weight) <= 0.0); ++i) {
        }
        return candidates.get(i);
    }

    private double computeWeight(class_1657 player, String trainerId, TrainerMobData mobTr) {
        PlayerState ps = PlayerState.get(player);
        if (!ps.canBattle(mobTr)) {
            return 0.0;
        }
        IServerConfig config = RCTMod.get().getServerConfig();
        TrainerManager tm = RCTMod.get().getTrainerManager();
        int playerLevel = tm.getPlayerLevel(player);
        int reqLevelCap = mobTr.getRequiredLevelCap();
        int levelCap = ps.getLevelCap();
        float keyTrainerFactor = 1.0f;
        if (ps.isKeyTrainer(mobTr) && tm.getBattleMemory((class_3218)player.method_37908(), trainerId).getDefeatByCount(player) == 0) {
            float a = (float)(10 - Math.min(9, levelCap / 10)) / 2.0f;
            float b = (float)Math.max(0, levelCap - playerLevel) * a + 1.0f;
            keyTrainerFactor = KEY_TRAINER_SPAWN_WEIGHT_FACTOR / b;
        }
        float undefeatedFactor = ps.getTrainerDefeatCount(trainerId) == 0 ? UNDEFEATED_WEIGHT_FACTOR : 1.0f;
        int diff = Math.abs(Math.min(playerLevel, levelCap) - reqLevelCap);
        return diff > config.maxLevelDiff() ? 0.0 : (double)((float)(config.maxLevelDiff() + 1 - diff) * mobTr.getSpawnWeightFactor() * undefeatedFactor * keyTrainerFactor);
    }

    private void track(TrainerMob trainer, UUID playerUUID) {
        TrainerManager tm;
        TrainerMobData trMob;
        class_1657 player;
        if (playerUUID != null && (player = trainer.method_37908().method_18470(playerUUID)) != null && (trMob = (tm = RCTMod.get().getTrainerManager()).getData(trainer)).getRewardLevelCap() > tm.getData(player).getLevelCap()) {
            PlayerState.get(player).setTarget(trainer.method_5628());
            this.tracked.put(playerUUID, trainer.method_5628());
        }
    }

    private void untrack(TrainerMob trainer, UUID playerUUID) {
        Integer id = this.tracked.get(playerUUID);
        if (id != null && trainer.method_5628() == id.intValue()) {
            class_1657 player = trainer.method_37908().method_18470(playerUUID);
            this.tracked.remove(playerUUID);
            if (player != null) {
                PlayerState.get(player).setTarget(-1);
            }
        }
    }

    private class SpawnCandidate {
        public final String id;
        public final double weight;

        public SpawnCandidate(String id, double weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

