/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.TrainerBattleMemoryLegacy;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class TrainerManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    private Map<String, TrainerMobData> trainerMobs = new HashMap<String, TrainerMobData>();
    private Map<UUID, TrainerBattle> trainerBattles = new HashMap<UUID, TrainerBattle>();
    private Function<class_1657, Integer> playerLevelSupplier;
    private Function<class_1657, Integer> activePokemonSupplier;

    public TrainerManager(Function<class_1657, Integer> playerLevelSupplier, Function<class_1657, Integer> activePokemonSupplier) {
        super(GSON, "rctmod");
        this.playerLevelSupplier = playerLevelSupplier;
        this.activePokemonSupplier = activePokemonSupplier;
    }

    public void addBattle(class_1657 initiator, TrainerMob opponent) {
        this.trainerBattles.put(initiator.method_5667(), new TrainerBattle(initiator, opponent));
    }

    public void addBattle(class_1657[] initiatorSidePlayers, TrainerMob[] initiatorSideMobs, class_1657[] trainerSidePlayers, TrainerMob[] trainerSideMobs) {
        TrainerBattle battle = new TrainerBattle(initiatorSidePlayers, initiatorSideMobs, trainerSidePlayers, trainerSideMobs);
        this.trainerBattles.put(battle.getInitiator().method_5667(), battle);
    }

    public Optional<TrainerBattle> getBattle(UUID initiatorId) {
        return this.trainerBattles.containsKey(initiatorId) ? Optional.of(this.trainerBattles.get(initiatorId)) : Optional.empty();
    }

    public boolean removeBattle(UUID initiatorId) {
        return this.trainerBattles.remove(initiatorId) != null;
    }

    public TrainerMobData getData(TrainerMob mob) {
        return this.getData(mob.getTrainerId());
    }

    public TrainerMobData getData(String trainerId) {
        if (!this.trainerMobs.containsKey(trainerId)) {
            return new TrainerMobData();
        }
        return this.trainerMobs.get(trainerId);
    }

    public boolean isValidId(String trainerId) {
        return this.trainerMobs.containsKey(trainerId);
    }

    public int getPlayerLevel(class_1657 player) {
        return this.playerLevelSupplier.apply(player);
    }

    public int getActivePokemon(class_1657 player) {
        return this.activePokemonSupplier.apply(player);
    }

    public TrainerPlayerData getData(class_1657 player) {
        return (TrainerPlayerData)player.method_5682().method_30002().method_17983().method_17924(TrainerPlayerData::of, TrainerPlayerData::new, TrainerPlayerData.filePath(player));
    }

    public Stream<Map.Entry<String, TrainerMobData>> getAllData() {
        return this.trainerMobs.entrySet().stream();
    }

    public TrainerBattleMemory getBattleMemory(TrainerMob mob) {
        return this.getBattleMemory(mob.method_5682().method_30002(), mob.getTrainerId());
    }

    public TrainerBattleMemory getBattleMemory(class_3218 level, String trainerId) {
        class_26 ds = level.method_17983();
        return (TrainerBattleMemory)ds.method_17924(TrainerBattleMemory::of, TrainerBattleMemoryLegacy.builder(trainerId, ds)::build, TrainerBattleMemory.filePath(trainerId));
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        DataPackManager dpm = RCTMod.get().getServerDataManager();
        dpm.init(resourceManager);
        this.trainerMobs.clear();
        dpm.listTrainerTeams((rl, io) -> {
            String trainerId = PathUtils.filename(rl.method_12832());
            dpm.loadResource(trainerId, "mobs", tdm -> this.trainerMobs.put(trainerId, (TrainerMobData)tdm), TrainerMobData.class);
        });
        dpm.close();
    }
}

