/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2960;

public class TrainerMobData
implements IDataPackObject {
    private Type type = Type.NORMAL;
    private int rewardLevelCap;
    private Map<Type, Integer> requiredDefeats = new HashMap<Type, Integer>();
    private int maxTrainerWins = 3;
    private int maxTrainerDefeats = 1;
    private int battleCooldownTicks = 2000;
    private float spawnWeightFactor = 1.0f;
    private Set<String> biomeTagBlacklist = new HashSet<String>();
    private Set<String> biomeTagWhitelist = new HashSet<String>();
    private transient Map<String, String[]> dialog = new HashMap<String, String[]>();
    private transient class_2960 textureResource;
    private transient class_2960 lootTableResource;
    private transient TrainerTeam team;

    public TrainerMobData() {
        this.textureResource = new class_2960("rctmod", "textures/trainers/default.png");
        this.lootTableResource = new class_2960("rctmod", "trainers/default");
        this.team = new TrainerTeam();
    }

    public TrainerMobData(TrainerMobData origin) {
        this.type = origin.type;
        this.rewardLevelCap = origin.rewardLevelCap;
        this.requiredDefeats = Map.copyOf(origin.requiredDefeats);
        this.maxTrainerWins = origin.maxTrainerWins;
        this.maxTrainerDefeats = origin.maxTrainerDefeats;
        this.battleCooldownTicks = origin.battleCooldownTicks;
        this.biomeTagBlacklist = Set.copyOf(origin.biomeTagBlacklist);
        this.biomeTagWhitelist = Set.copyOf(origin.biomeTagWhitelist);
        this.dialog = Map.copyOf(origin.dialog);
        this.textureResource = origin.textureResource;
        this.lootTableResource = origin.lootTableResource;
        this.team = origin.team;
    }

    public Type getType() {
        return this.type;
    }

    public int getRewardLevelCap() {
        return this.rewardLevelCap < 100 ? Math.max(0, Math.min(100, this.rewardLevelCap + RCTMod.get().getServerConfig().bonusLevelCap())) : 100;
    }

    public int getRequiredLevelCap() {
        int bonus = RCTMod.get().getServerConfig().bonusLevelCap();
        return Math.max(0, Math.min(100, this.getTeam().getMembers().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) + bonus));
    }

    public int getRequiredDefeats(Type type) {
        return this.requiredDefeats.getOrDefault((Object)type, 0);
    }

    public int getMaxTrainerWins() {
        return this.maxTrainerWins;
    }

    public int getMaxTrainerDefeats() {
        return this.maxTrainerDefeats;
    }

    public int getBattleCooldownTicks() {
        return this.battleCooldownTicks;
    }

    public float getSpawnWeightFactor() {
        return this.spawnWeightFactor;
    }

    public Set<String> getBiomeTagBlacklist() {
        return Collections.unmodifiableSet(this.biomeTagBlacklist);
    }

    public Set<String> getBiomeTagWhitelist() {
        return Collections.unmodifiableSet(this.biomeTagWhitelist);
    }

    public Map<String, String[]> getDialog() {
        return Collections.unmodifiableMap(this.dialog);
    }

    public class_2960 getTextureResource() {
        return this.textureResource;
    }

    public class_2960 getLootTableResource() {
        return this.lootTableResource;
    }

    public TrainerTeam getTeam() {
        return this.team;
    }

    @Override
    public void onLoad(DataPackManager dpm, String trainerId, String context) {
        Optional<TrainerTeam> team;
        Optional<class_2960> lootTableResource = dpm.findResource(trainerId, "loot_tables");
        Optional<class_2960> textureResource = dpm.findResource(trainerId, "textures");
        if (textureResource.isPresent()) {
            this.textureResource = textureResource.get();
        }
        if (lootTableResource.isPresent()) {
            this.lootTableResource = new class_2960("rctmod", lootTableResource.get().method_12832().replace("loot_tables/", "").replace(".json", ""));
        }
        dpm.loadResource(trainerId, "dialogs", dialog -> {
            this.dialog = dialog;
        }, new TypeToken<Map<String, String[]>>(){});
        if (this.dialog == null) {
            this.dialog = new HashMap<String, String[]>();
        }
        if ((team = dpm.loadTrainerTeam(trainerId)).isPresent()) {
            this.team = team.get();
        }
    }

    public static enum Type {
        NORMAL,
        LEADER,
        BOSS,
        E4,
        CHAMP,
        TEAM_ROCKET,
        RIVAL;

        private static final Map<Type, String> symbols;
        private static final Map<Type, Integer> colors;

        public String toString() {
            return symbols.getOrDefault((Object)this, "");
        }

        public int toColor() {
            return colors.getOrDefault((Object)this, class_124.field_1068.method_532());
        }

        static {
            symbols = Map.of(LEADER, "[L]", BOSS, "[B]", E4, "[E]", CHAMP, "[C]", TEAM_ROCKET, "[T]", RIVAL, "[R]");
            colors = Map.of(LEADER, class_124.field_1060.method_532(), BOSS, class_124.field_1065.method_532(), E4, class_124.field_1078.method_532(), CHAMP, class_124.field_1076.method_532(), TEAM_ROCKET, class_124.field_1063.method_532());
        }
    }
}

