/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.api.config.ICommonConfig;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.service.IConfigs;
import com.gitlab.srcmc.rctmod.api.service.ILootConditions;
import com.gitlab.srcmc.rctmod.api.service.IPlayerController;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.gitlab.srcmc.rctmod.world.loot.conditions.DefeatCountCondition;
import com.gitlab.srcmc.rctmod.world.loot.conditions.LevelRangeCondition;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_3264;

public final class RCTMod {
    private TrainerManager trainerManager = new TrainerManager(playerController::getPlayerLevel, playerController::getActivePokemonCount);
    private DataPackManager clientDataManager = new DataPackManager(class_3264.field_14188);
    private DataPackManager serverDataManager = new DataPackManager(class_3264.field_14190);
    private TrainerSpawner trainerSpawner = new TrainerSpawner();
    private IPlayerController playerController;
    private IConfigs configs;
    private static Supplier<RCTMod> instance = () -> {
        throw new RuntimeException(RCTMod.class.getName() + " not initialized");
    };

    public static RCTMod get() {
        return instance.get();
    }

    public static void init(IPlayerController playerController, ILootConditions lootConditions, IConfigs configs) {
        LevelRangeCondition.init(lootConditions::levelRangeConditon);
        DefeatCountCondition.init(lootConditions::defeatCountConditon);
        RCTMod local = new RCTMod(playerController, configs);
        instance = () -> local;
    }

    private RCTMod(IPlayerController playerController, IConfigs configs) {
        this.playerController = playerController;
        this.configs = configs;
    }

    public TrainerManager getTrainerManager() {
        return this.trainerManager;
    }

    public DataPackManager getClientDataManager() {
        return this.clientDataManager;
    }

    public DataPackManager getServerDataManager() {
        return this.serverDataManager;
    }

    public TrainerSpawner getTrainerSpawner() {
        return this.trainerSpawner;
    }

    public IClientConfig getClientConfig() {
        return this.configs.clientConfig();
    }

    public ICommonConfig getCommonConfig() {
        return this.configs.commonConfig();
    }

    public IServerConfig getServerConfig() {
        return this.configs.serverConfig();
    }

    public boolean makeBattle(TrainerMob source, class_1657 target) {
        try {
            this.playerController.startBattle(source, target);
        }
        catch (Exception e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void stopBattle(TrainerMob mob) {
        this.playerController.stopBattle(mob);
    }

    public boolean isInBattle(class_1657 player) {
        return this.playerController.isInBattle(player);
    }
}

