/*
 * Decompiled with CFR 0.152.
 */
package games.dragonhowl.megamons.common;

import games.dragonhowl.megamons.common.Megamons;
import games.dragonhowl.megamons.common.MegamonsImplementation;
import games.dragonhowl.megamons.common.config.MegamonsConfig;
import games.dragonhowl.megamons.common.event.Events;
import games.dragonhowl.megamons.common.world.feature.MegamonsPlacedFeatures;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b&\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u0004R\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\rR\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010\tR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b!\u0010#\"\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lgames/dragonhowl/megamons/common/Megamons;", "", "", "initialize", "()V", "loadConfig", "Lgames/dragonhowl/megamons/common/MegamonsImplementation;", "implementation", "preInitialize", "(Lgames/dragonhowl/megamons/common/MegamonsImplementation;)V", "registerEvents", "", "CONFIG_PATH", "Ljava/lang/String;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "MODID", "VERSION", "Lgames/dragonhowl/megamons/common/config/MegamonsConfig;", "config", "Lgames/dragonhowl/megamons/common/config/MegamonsConfig;", "getConfig", "()Lgames/dragonhowl/megamons/common/config/MegamonsConfig;", "setConfig", "(Lgames/dragonhowl/megamons/common/config/MegamonsConfig;)V", "Lgames/dragonhowl/megamons/common/MegamonsImplementation;", "getImplementation", "()Lgames/dragonhowl/megamons/common/MegamonsImplementation;", "setImplementation", "", "isDedicatedServer", "Z", "()Z", "setDedicatedServer", "(Z)V", "<init>", "common"})
public final class Megamons {
    @NotNull
    public static final Megamons INSTANCE = new Megamons();
    @NotNull
    public static final String MODID = "megamons";
    @NotNull
    public static final String VERSION = "1.3.0";
    @NotNull
    public static final String CONFIG_PATH = "config/megamons/main.json";
    @NotNull
    private static final Logger LOGGER;
    public static MegamonsImplementation implementation;
    private static boolean isDedicatedServer;
    public static MegamonsConfig config;

    private Megamons() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final MegamonsImplementation getImplementation() {
        MegamonsImplementation megamonsImplementation = implementation;
        if (megamonsImplementation != null) {
            return megamonsImplementation;
        }
        Intrinsics.throwUninitializedPropertyAccessException("implementation");
        return null;
    }

    public final void setImplementation(@NotNull MegamonsImplementation megamonsImplementation) {
        Intrinsics.checkNotNullParameter(megamonsImplementation, "<set-?>");
        implementation = megamonsImplementation;
    }

    public final boolean isDedicatedServer() {
        return isDedicatedServer;
    }

    public final void setDedicatedServer(boolean bl) {
        isDedicatedServer = bl;
    }

    @NotNull
    public final MegamonsConfig getConfig() {
        MegamonsConfig megamonsConfig = config;
        if (megamonsConfig != null) {
            return megamonsConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    public final void setConfig(@NotNull MegamonsConfig megamonsConfig) {
        Intrinsics.checkNotNullParameter(megamonsConfig, "<set-?>");
        config = megamonsConfig;
    }

    public final void preInitialize(@NotNull MegamonsImplementation implementation) {
        Intrinsics.checkNotNullParameter(implementation, "implementation");
        INSTANCE.setImplementation(implementation);
        LOGGER.info("Initialzing Megamons ...");
        implementation.registerItems();
        implementation.registerBlocks();
        implementation.registerWorldGenFeatures();
        this.loadConfig();
        MegamonsPlacedFeatures.INSTANCE.register();
    }

    public final void initialize() {
        this.registerEvents();
    }

    public final void loadConfig() {
        File configFile = new File(CONFIG_PATH);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                Object object = MegamonsConfig.Companion.getGSON().fromJson((Reader)fileReader, MegamonsConfig.class);
                Intrinsics.checkNotNullExpressionValue(object, "MegamonsConfig.GSON.from\u2026gamonsConfig::class.java)");
                this.setConfig((MegamonsConfig)object);
                fileReader.close();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load the config! Using defaults... Error:");
                this.setConfig(new MegamonsConfig());
                exception.printStackTrace();
            }
        } else {
            this.setConfig(new MegamonsConfig());
        }
    }

    public final void registerEvents() {
        Events.pokemonHeldItemChange.subscribe(registerEvents.1.INSTANCE);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger()");
        LOGGER = logger;
    }
}

