/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;

public class ConstructorThisCallExpression
extends Expression {
    public final TypeID objectType;
    public final FunctionalMemberRef constructor;
    public final CallArguments arguments;

    public ConstructorThisCallExpression(CodePosition position, TypeID type, FunctionalMemberRef constructor, CallArguments arguments) {
        super(position, BasicTypeID.VOID, ConstructorThisCallExpression.binaryThrow(position, constructor.getHeader().thrownType, ConstructorThisCallExpression.multiThrow(position, arguments.arguments)));
        if (type instanceof BasicTypeID) {
            throw new IllegalArgumentException("Type cannot be basic type");
        }
        this.objectType = type;
        this.constructor = constructor;
        this.arguments = arguments;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitConstructorThisCall(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitConstructorThisCall(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        CallArguments tArguments = this.arguments.transform(transformer);
        return tArguments == this.arguments ? this : new ConstructorThisCallExpression(this.position, this.objectType, this.constructor, tArguments);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return new ConstructorThisCallExpression(this.position, this.objectType, this.constructor, this.arguments.normalize(this.position, scope, this.constructor.getHeader()));
    }
}

