/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.ref.ConstMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;

public class ConstExpression
extends Expression {
    public final ConstMemberRef constant;

    public ConstExpression(CodePosition position, ConstMemberRef constant) {
        super(position, constant.getType(), null);
        this.constant = constant;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitConst(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitConst(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        return this;
    }

    @Override
    public String evaluateStringConstant() {
        return this.constant.member.value.evaluateStringConstant();
    }

    @Override
    public EnumConstantMember evaluateEnumConstant() {
        return this.constant.member.value.evaluateEnumConstant();
    }

    @Override
    public IDefinitionMember getMember() {
        return this.constant.member;
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return this;
    }
}

