/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CapturedExpression;
import org.openzen.zenscript.codemodel.expression.CapturedExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.scope.TypeScope;

public class CapturedClosureExpression
extends CapturedExpression {
    public final CapturedExpression value;

    public CapturedClosureExpression(CodePosition position, CapturedExpression value, LambdaClosure closure) {
        super(position, value.type, closure);
        this.value = value;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitCapturedClosure(this);
    }

    @Override
    public <T> T accept(CapturedExpressionVisitor<T> visitor) {
        return visitor.visitRecaptured(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitCapturedClosure(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tValue = transformer.transform(this.value);
        if (!(tValue instanceof CapturedExpression)) {
            throw new IllegalStateException("Transformed CapturedExpression must also be a CapturedExpression!");
        }
        return tValue == this.value ? this : new CapturedClosureExpression(this.position, (CapturedExpression)tValue, this.closure);
    }

    @Override
    public CapturedExpression normalize(TypeScope scope) {
        return new CapturedClosureExpression(this.position, this.value.normalize(scope), this.closure);
    }
}

