/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class RecipeList<T extends class_1860<?>> {
    private final class_3956<T> recipeType;
    private final Map<class_2960, T> recipes;
    private final Map<class_2960, class_1860<?>> byName;
    private final Map<class_2960, T> unmodifiableRecipes;
    private final Map<class_2960, class_1860<?>> unmodifiableByName;

    public RecipeList(class_3956<T> recipeType, Map<class_2960, T> recipes, Map<class_2960, class_1860<?>> byName) {
        this.recipeType = recipeType;
        this.recipes = recipes;
        this.byName = byName;
        this.unmodifiableRecipes = Collections.unmodifiableMap(recipes);
        this.unmodifiableByName = Collections.unmodifiableMap(byName);
    }

    public List<T> getRecipesByOutput(IIngredient output) {
        return this.getRecipes().values().stream().filter(recipe -> output.matches(IItemStack.ofMutable(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1860)recipe).method_8110(arg_0))))).toList();
    }

    public List<T> getAllRecipes() {
        return new ArrayList<T>(this.getRecipes().values());
    }

    public T get(class_2960 id) {
        return (T)((class_1860)this.getRecipes().get(id));
    }

    public T get(String id) {
        return this.get(class_2960.method_12829((String)id));
    }

    public boolean has(class_2960 id) {
        return this.getRecipes().containsKey(id);
    }

    public boolean has(String id) {
        return this.has(class_2960.method_12829((String)id));
    }

    public void add(class_2960 id, T recipe) {
        if (this.getByName().containsKey(recipe.method_8114())) {
            CommonLoggers.api().warn("A recipe with the name '{}' already exists and will be overwritten: this is most likely an error in your scripts", (Object)recipe.method_8114().method_12832());
        }
        this.recipes.put(id, recipe);
        this.byName.put(id, (class_1860<?>)recipe);
    }

    public void remove(class_2960 id) {
        this.recipes.remove(id);
        this.byName.remove(id);
    }

    public void removeByRecipeTest(Predicate<T> recipePredicate) {
        Iterator<class_2960> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            class_2960 next = iterator.next();
            class_1860 recipe = (class_1860)this.recipes.get(next);
            if (!recipePredicate.test(recipe)) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeByIdTest(Predicate<class_2960> idPredicate) {
        this.removeByIdTest(idPredicate, s -> false);
    }

    public void removeByIdTest(Predicate<class_2960> idPredicate, Predicate<String> exclusions) {
        Iterator<class_2960> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            class_2960 next = iterator.next();
            if (!idPredicate.test(next) || exclusions.test(next.method_12832())) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeAll() {
        this.byName.keySet().removeAll(this.recipes.keySet());
        this.recipes.clear();
    }

    public class_3956<T> getRecipeType() {
        return this.recipeType;
    }

    public Map<class_2960, T> getRecipes() {
        return this.unmodifiableRecipes;
    }

    public Map<class_2960, class_1860<?>> getByName() {
        return this.unmodifiableByName;
    }

    public int getSize() {
        return this.getRecipes().size();
    }
}

