/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientConditioned;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@ParametersAreNonnullByDefault
public enum IngredientConditionedSerializer implements CustomIngredientSerializer<IngredientConditioned<?, ?>>
{
    INSTANCE;


    public class_2960 getIdentifier() {
        return IIngredientConditioned.ID;
    }

    public IngredientConditioned<?, ?> read(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(class_1856.method_52177((JsonElement)base));
        JsonObject condition = json.getAsJsonObject("condition");
        class_2960 type = new class_2960(condition.get("type").getAsString());
        IIngredientConditionSerializer value = (IIngredientConditionSerializer)CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.method_10223(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new IIngredientConditioned<IIngredient>(baseIngredient, (IIngredientCondition<IIngredient>)value.fromJson(condition)));
    }

    public void write(JsonObject json, IngredientConditioned<?, ?> ingredient) {
        json.add("base", ((IIngredientConditioned)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().method_8089());
        IIngredientCondition<?> condition = ingredient.getCondition();
        JsonObject value = condition.toJson();
        if (!value.has("type")) {
            value.addProperty("type", condition.getType().toString());
        }
        json.add("condition", (JsonElement)value);
    }

    public IngredientConditioned<?, ?> read(class_2540 buffer) {
        IIngredient base = IIngredient.fromIngredient(class_1856.method_8086((class_2540)buffer));
        class_2960 type = buffer.method_10810();
        IIngredientConditionSerializer value = (IIngredientConditionSerializer)CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.method_10223(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientConditioned(new IIngredientConditioned<IIngredient>(base, (IIngredientCondition<IIngredient>)value.fromNetwork(buffer)));
    }

    public void write(class_2540 buffer, IngredientConditioned<?, ?> ingredient) {
        class_1856 baseIngredient = ((IIngredientConditioned)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.method_8088(buffer);
        IIngredientCondition<?> condition = ingredient.getCondition();
        IIngredientConditionSerializer serializer = condition.getSerializer();
        buffer.method_10812(serializer.getType());
        condition.write(buffer);
    }
}

