/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.LongData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.SimpleFluidStack;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStack
implements IFluidStack {
    private final SimpleFluidStack stack;

    public MCFluidStack(SimpleFluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public long getAmount() {
        return this.getInternal().amount();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        SimpleFluidStack copy = this.getInternal().copy();
        copy.amount(amount);
        return IFluidStack.of(copy);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public class_3611 getFluid() {
        return this.getInternal().fluid();
    }

    @Override
    public IFluidStack withTag(@ZenCodeType.Nullable IData tag) {
        SimpleFluidStack copy = this.getInternal().copy();
        if (tag != null) {
            MapData map = new MapData(tag.asMap());
            copy.tag(map.getInternal());
        } else {
            copy.tag(null);
        }
        return IFluidStack.of(copy);
    }

    @Override
    public boolean hasTag() {
        return this.getInternal().tag() != null;
    }

    @Override
    public IData getTag() {
        return TagToDataConverter.convert((class_2520)this.getInternal().tag());
    }

    @Override
    public class_2487 getInternalTag() {
        return this.getInternal().tag();
    }

    public SimpleFluidStack getInternal() {
        return this.stack;
    }

    public SimpleFluidStack getImmutableInternal() {
        return this.stack.copy();
    }

    @Override
    public IData asIData() {
        IData data = IFluidStack.super.asIData();
        data.put("amount", new LongData(this.getAmount()));
        return data;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFluidStack thatStack = ((MCFluidStack)o).getInternal();
        SimpleFluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.amount() != thatStack.amount()) {
            return false;
        }
        if (!Objects.equals(thisStack.fluid(), thatStack.fluid())) {
            return false;
        }
        return Objects.equals(thisStack.tag(), thatStack.tag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().amount(), this.getInternal().fluid(), this.getInternal().tag());
    }
}

