/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.ResourceLocationBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_7923;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="attribute")
    public static class_1320 getAttribute(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Attribute BEP <attribute:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Syntax is <attribute:modid:name>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        return (class_1320)class_7923.field_41190.method_17966(key).orElseThrow(() -> new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Attribute does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="block")
    public static class_2248 getBlock(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Block BEP <block:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Syntax is <block:modid:itemname>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        return (class_2248)class_7923.field_41175.method_17966(key).orElseThrow(() -> new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Block does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="fluid")
    public static IFluidStack getFluidStack(String tokens) {
        class_2960 resourceLocation = class_2960.method_12829((String)tokens);
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Could not get fluid for <fluid:" + tokens + ">. Syntax is <fluid:modid:fluidname>");
        }
        if (!class_7923.field_41173.method_10250(resourceLocation)) {
            throw new IllegalArgumentException("Could not get fluid for <fluid:" + tokens + ">. Fluid does not appear to exist!");
        }
        return IFluidStack.of((class_3611)class_7923.field_41173.method_10223(resourceLocation), 1L);
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static class_2680 getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("BlockState BEP <blockstate:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String blockName = split[0] + ":" + split[1];
            String properties = split.length > 2 ? split[2] : "";
            Optional found = class_7923.field_41175.method_17966(new class_2960(blockName));
            if (found.isEmpty()) {
                IllegalArgumentException t = new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not appear to exist!");
                CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)t);
            } else {
                return BracketHandlers.getBlockState((class_2248)found.get(), blockName, properties);
            }
        }
        CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"));
        return null;
    }

    public static class_2680 getBlockState(String name, String properties) {
        return BracketHandlers.getBlockState((class_2248)class_7923.field_41175.method_10223(new class_2960(name)), name, properties);
    }

    public static class_2680 getBlockState(class_2248 block, String name, String properties) {
        class_2680 blockState = block.method_9564();
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CommonLoggers.zenCode().warn("Invalid blockstate property format '{}'. Using default property value.", (Object)propertyPair);
                    continue;
                }
                blockState = ExpandBlockState.withProperty(blockState, splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @BracketResolver(value="mobeffect")
    @ZenCodeType.Method
    public static class_1291 getMobEffect(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("MobEffect BEP <mobeffect:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get effect with name: <mobeffect:" + tokens + ">! Syntax is <effect:modid:mobeffect>");
        }
        return (class_1291)class_7923.field_41174.method_17966(new class_2960(split[0], split[1])).orElseThrow(() -> new IllegalArgumentException("Could not get effect with name: <mobeffect:" + tokens + ">! Effect does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="enchantment")
    public static class_1887 getEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Enchantment BEP <enchantment:{}> does not seem to be lower-case!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': not a valid bracket handler, syntax is <enchantment:modid:name>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        Optional found = class_7923.field_41176.method_17966(key);
        if (found.isEmpty()) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': the enchantment does not appear to exist");
        }
        return (class_1887)found.get();
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static class_1299<class_1297> getEntityType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">");
        }
        class_2960 resourceLocation = new class_2960(tokens);
        return (class_1299)GenericUtil.uncheck(class_7923.field_41177.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">")));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Item BEP <item:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        class_1799 stack = class_7923.field_41178.method_17966(key).map(class_1799::new).orElseThrow(() -> new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!"));
        return IItemStack.of(stack);
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static class_1842 getPotion(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Potion BEP <potion:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Syntax is <potion:modid:potionname>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        return (class_1842)class_7923.field_41179.method_17966(key).orElseThrow(() -> new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Potion does not appear to exist!"));
    }

    @ZenCodeType.Method
    public static IRecipeManager<?> getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("RecipeType BEP <recipetype:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        class_2960 key = new class_2960(tokens);
        IRecipeManager<class_1860<?>> result = RecipeTypeBracketHandler.getOrDefault(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not appear to exist!");
    }

    @Deprecated(forRemoval=true)
    @ZenCodeType.Method
    public static class_2960 getResourceLocation(String tokens) {
        return ResourceLocationBracketHandler.getResourceLocation(tokens);
    }

    @ZenCodeType.Method
    @BracketResolver(value="profession")
    public static class_3852 getProfession(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get profession <profession:" + tokens + ">");
        }
        class_2960 resourceLocation = new class_2960(tokens);
        return (class_3852)class_7923.field_41195.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get profession with name: <profession:" + tokens + ">! Profession does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="soundevent")
    public static class_3414 getSoundEvent(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get sound event <soundevent:" + tokens + ">");
        }
        class_2960 resourceLocation = new class_2960(tokens);
        return (class_3414)class_7923.field_41172.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get sound event with name: <soundevent:" + tokens + ">! Sound event does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="targetingstrategy")
    public static ITargetingStrategy getTargetingStrategy(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Targeting strategy BEP <targetingstrategy:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get targeting strategy with <targetingstrategy:" + tokens + ">: syntax is <targetingstrategy:modid:name>");
        }
        class_2960 key = new class_2960(split[0], split[1]);
        return ITargetingStrategy.find(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="villagertype")
    public static class_3854 getVillagerType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get profession <villagertype:" + tokens + ">");
        }
        class_2960 resourceLocation = new class_2960(tokens);
        return (class_3854)class_7923.field_41194.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get villagertype with name: <villagertype:" + tokens + ">! Villager Type does not appear to exist!"));
    }
}

