/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.net;

import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.net.ModPacket;
import bigchadguys.dailyshop.world.data.DailyShopData;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_634;

public class DailyShopUpdateS2CPacket
extends ModPacket<class_634> {
    private Map<String, DailyShopData.Entry> entries;

    public DailyShopUpdateS2CPacket() {
    }

    public DailyShopUpdateS2CPacket(String id, DailyShopData.Entry entry) {
        this.entries = new LinkedHashMap<String, DailyShopData.Entry>();
        this.entries.put(id, entry);
    }

    public DailyShopUpdateS2CPacket(Map<String, DailyShopData.Entry> entries) {
        this.entries = entries;
    }

    @Override
    public void onReceive(class_634 listener) {
        if (this.entries != null) {
            this.entries.forEach((id, shop) -> {
                if (shop != null) {
                    DailyShopData.CLIENT.getEntries().put((String)id, (DailyShopData.Entry)shop);
                } else {
                    DailyShopData.CLIENT.getEntries().remove(id);
                }
            });
        } else {
            DailyShopData.CLIENT.getEntries().clear();
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.BOOLEAN.writeBits(this.entries != null, buffer);
        if (this.entries != null) {
            Adapters.INT_SEGMENTED_3.writeBits(this.entries.size(), buffer);
            this.entries.forEach((id, entry) -> {
                Adapters.UTF_8.asNullable().writeBits((String)id, buffer);
                Adapters.SHOP_ENTRY.writeBits((DailyShopData.Entry)entry, buffer);
            });
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
            this.entries = new LinkedHashMap<String, DailyShopData.Entry>();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                this.entries.put(Adapters.UTF_8.asNullable().readBits(buffer).orElse(null), Adapters.SHOP_ENTRY.readBits(buffer).orElse(null));
            }
        } else {
            this.entries = null;
        }
    }
}

