/*
 * Decompiled with CFR 0.152.
 */
package bigchadguys.dailyshop.data.tile;

import bigchadguys.dailyshop.data.adapter.Adapters;
import bigchadguys.dailyshop.data.adapter.ISimpleAdapter;
import bigchadguys.dailyshop.data.adapter.array.ArrayAdapter;
import bigchadguys.dailyshop.data.bit.BitBuffer;
import bigchadguys.dailyshop.data.nbt.PartialCompoundNbt;
import bigchadguys.dailyshop.data.tile.OrTilePredicate;
import bigchadguys.dailyshop.data.tile.PartialBlockGroup;
import bigchadguys.dailyshop.data.tile.PartialBlockState;
import bigchadguys.dailyshop.data.tile.PartialBlockTag;
import bigchadguys.dailyshop.data.tile.PartialTile;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

@FunctionalInterface
public interface TilePredicate {
    public static final TilePredicate FALSE = (state, nbt) -> false;
    public static final TilePredicate TRUE = (state, nbt) -> true;

    public boolean test(PartialBlockState var1, PartialCompoundNbt var2);

    default public boolean test(PartialTile tile) {
        return this.test(tile.getState(), tile.getEntity());
    }

    default public boolean test(class_1922 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2586 entity = world.method_8321(pos);
        return this.test(PartialBlockState.of(state), PartialCompoundNbt.of(entity));
    }

    public static TilePredicate of(class_2248 block) {
        return (state, nbt) -> state.getBlock().asWhole().map(other -> other == block).orElse(false);
    }

    public static Optional<TilePredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialBlockTag.parse(string, logErrors);
            case '@' -> PartialBlockGroup.parse(string, logErrors);
            default -> PartialTile.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<TilePredicate, class_2520, JsonElement> {
        private static ArrayAdapter<TilePredicate> LIST = Adapters.ofArray(TilePredicate[]::new, new Adapter());

        @Override
        public void writeBits(TilePredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrTilePredicate) {
                    OrTilePredicate or = (OrTilePredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((TilePredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<TilePredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrTilePredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> TilePredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<class_2520> writeNbt(TilePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrTilePredicate) {
                OrTilePredicate or = (OrTilePredicate)value;
                return LIST.writeNbt((TilePredicate)or.getChildren());
            }
            return Optional.of(class_2519.method_23256((String)value.toString()));
        }

        @Override
        public Optional<TilePredicate> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof class_2499) {
                class_2499 list = (class_2499)nbt;
                return LIST.readNbt(list).map(OrTilePredicate::new);
            }
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return Optional.of(TilePredicate.of(string.method_10714(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(TilePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrTilePredicate) {
                OrTilePredicate or = (OrTilePredicate)value;
                return LIST.writeJson((TilePredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<TilePredicate> readJson(JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrTilePredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(TilePredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

